{ screen saver - automatic tetris player }
{ /play option = play tetris }
{ (x) 2000 http://z0mbie.cjb.net }

uses crt;

const
  maxx = 24;
  maxy = 23;

  tetchr = '';

  N_CYCLE      = 20;
  N_DELAY      = 0;  {40}
  N_DELAY_DOWN = 0;  {10}

  emptychr : char = #0;
  play : integer = 0;

const
  pcount:longint=0;
  lcount:longint=0;
  gcount:longint=0;

procedure TextAddr(X, Y : Integer); assembler;
  asm
    XOR DX, DX
    MOV ES, DX
    MOV AX, Y
    DEC AX
    MUL WORD PTR ES:[044AH]  { columns }
    ADD AX, X
    DEC AX
    ADD AX, AX
    XCHG DI, AX
    MOV AX, SEGB800          { SegB800 = VideoSeg }
    MOV ES, AX
  end;

procedure Print(X, Y : Integer; C : Byte; S : String); assembler;
  asm
    PUSH DS
    PUSH X
    PUSH Y
    CALL TextAddr
    LDS SI, S
    CLD
    LODSB
    MOV CL, AL
    XOR CH, CH
    JCXZ @@2
    MOV AH, C
@@1:LODSB
    STOSW
    LOOP @@1
@@2:POP DS
  end;

procedure CPrint(X, Y : Integer; C1, C2 : Byte; S : String); assembler;
  asm
    PUSH DS
    PUSH X
    PUSH Y
    CALL TextAddr
    LDS SI, S
    CLD
    LODSB
    MOV CL, AL
    XOR CH, CH
    JCXZ @@4
    MOV AH, C1
@@1:LODSB
    CMP AL, '~'
    JNE @@2
    XOR AH, C1
    XOR AH, C2
    JMP @@3
@@2:STOSW
@@3:LOOP @@1
@@4:POP DS
  end;

function FStr(L,N : Longint) : String;
  var
    S : String;
  begin
    Str(L:N, S);
    FStr := S;
  end;

procedure updinfo;
  begin
    cprint(1,11,2,10,'games  : ~'+fstr(gcount,5));
    cprint(1,12,2,10,'lines  : ~'+fstr(lcount,5));
    cprint(1,13,2,10,'pieces : ~'+fstr(pcount,5));
    cprint(1,14,2,10,'k      : ~'+fstr(lcount*100 div pcount,5)+'~%');
  end;

var
  buf,buf2:array[0..4095] of byte;

var
  a:array[0..maxy-1,0..maxx-1] of byte;

procedure init_a;
begin
  fillchar(a,sizeof(a),0);
end;

procedure draw_a;
var
  x,y,t:integer;
  c1,c2:char;
begin
  for y:=0 to maxy-1 do
  for x:=0 to maxx-1 do
  begin
    t := (12-maxy div 2+y)*160+(40-maxx+x*2)*2;
    if a[y,x]=0 then begin
      if emptychr=#0 then begin
        memw[segb800:t  ]:=word(pointer(@buf2[t])^);
        memw[segb800:t+2]:=word(pointer(@buf2[t+2])^);
      end else begin
        memw[segb800:t  ]:=ord(emptychr)+8 shl 8;
        memw[segb800:t+2]:=ord(emptychr)+8 shl 8;
      end;
    end else begin
      memw[segb800:t  ]:=ord(tetchr)+a[y,x] shl 8;
      memw[segb800:t+2]:=ord(tetchr)+a[y,x] shl 8;
    end;
  end;
end;


var
  b,b0,t:array[0..4,0..4] of byte;
  b_miny,br,bc,bx,by:integer;

procedure check_a;
  label c1;
  var
    t,x,y:integer;
  begin
    for y:=maxy-1 downto 1 do
    begin
      for x:=0 to maxx-1 do
        if a[y,x]=0 then goto c1;
      for x:=0 to maxx-1 do
      begin
        if bx-x >=0 then if bx-x<maxx then a[y,bx-x]:=8;
        if bx+x >=0 then if bx+x<maxx then a[y,bx+x]:=8;
        draw_a;
        delay(5);
      end;
      for t:=y downto 1 do
        move(a[t-1,0],a[t,0],maxx);
      fillchar(a[0,0],maxx,0);
      dec(y);
      inc(lcount);
      updinfo;
c1:
    end;
  end;

procedure rot_b(i:integer);
  var
    x,y:integer;
  begin
    move(b0,b,sizeof(b));
    for i:=1 to i do
    begin
      move(b,t,sizeof(t));
      b_miny:=5;
      for x:=0 to 4 do
      for y:=0 to 4 do
      begin
        b[y,x]:=t[x,4-y];
        if b[y,x]=ord('x') then
        if y<b_miny then
          b_miny:=y;
      end;
    end;
  end;

procedure init_b;
  var
    s:string;
    i:integer;
  begin

    bx:=maxx div 2-2;
    by:=0;
    bc:=1+random(16);

    case bc of
      1: s:='.....'+
            '.xxx.'+
            '...x.'+
            '.....'+
            '.....';

      2: s:='.....'+
            '.xxx.'+
            '.x...'+
            '.....'+
            '.....';

      3: s:='.....'+
            '.....'+
            '..x..'+
            '.xxx.'+
            '.....';

      4: s:='.....'+
            '.....'+
            '.xx..'+
            '..xx.'+
            '.....';

      5: s:='.....'+
            '.....'+
            '..xx.'+
            '.xx..'+
            '.....';

      6: s:='.....'+
            '.....'+
            'xxxxx'+
            '.....'+
            '.....';

      7: s:='.....'+
            '..x..'+
            '.xxx.'+
            '.x.x.'+
            '.....';

      8: s:='.....'+
            '..x..'+
            '.xxx.'+
            '..x..'+
            '.....';

      9: s:='.....'+
            '.xxx.'+
            '...x.'+
            '...x.'+
            '.....';
     10: s:='.....'+
            '...x.'+
            '...x.'+
            '.xxx.'+
            '.....';


     11: s:='.....'+
            '.....'+
            '.xxx.'+
            '.....'+
            '.....';

     12: s:='.....'+
            '..x..'+
            '..x..'+
            '.....'+
            '.....';

     13: s:='.....'+
            '..x..'+
            '..xx.'+
            '.....'+
            '.....';

     14: s:='.....'+
            '.....'+
            '..xx.'+
            '..xx.'+
            '.....';

     15: s:='.....'+
            '.....'+
            '..x..'+
            '.....'+
            '.....';

     16: s:='.....'+
            '.x...'+
            '.xx..'+
            '..xx.'+
            '.....';

    end;

    bc:=1+random(bc mod 15);

    move(s[1],b0,sizeof(b0));

    br:=1+random(4);
    rot_b(br);
  end;

function can_apply_b : boolean;
  var
    x,y:integer;
  begin
    can_apply_b := false;
    for y:=0 to 4 do
    for x:=0 to 4 do
    if b[y,x]=ord('x') then
    begin
      if (bx+x<0) or (bx+x>=maxx) or
         (by+y<0) or (by+y>=maxy) then exit;
      if (a[by+y,bx+x]<>0) then exit;
    end;
    can_apply_b := true;
  end;

procedure apply_b(c:integer);
  var
    x,y:integer;
  begin
    for y:=0 to 4 do
    for x:=0 to 4 do
      if b[y,x]=ord('x') then
      if (bx+x>=0) and (bx+x<maxx) and (by+y>=0) and (by+y<maxy) then
        a[by+y,bx+x] := c;
  end;

var
  _bx,_by,_br : integer;

procedure findbest;

  function calc_sum:integer;
    var
      x,y,s:integer;
    begin
      s:=0;
      for x:=0 to maxx-1 do
      begin
        for y:=0 to maxy-1 do
          if a[y,x]=0 then begin
            inc(s);
          end else
            break;
      end;
      calc_sum := s;
    end;

  var
    save_bx,save_by,save_br:integer;
    i,s0,t,v:integer;

    max : integer;
    arr : array[1..1024] of record bx,by,br:integer; end;
  begin
    save_bx:=bx;
    save_by:=by;
    save_br:=br;

    s0:=calc_sum;

    v:=-1;
    for br:=0 to 3 do
    begin
      rot_b(br);
      for bx:=-4 to maxx+4 do
      begin
        by:=0;

        if can_apply_b then
        begin
          repeat
            inc(by);
          until not can_apply_b;
          dec(by);

          apply_b(bc);
          {t:=(s0-calc_sum+1) * (maxy-1-(by+b_miny));}
          {t:= (s0-calc_sum+1) + (maxy-1-(by+b_miny));}
          {t:= (s0-calc_sum) * 3 + (maxy-1-(by+b_miny));}
          {t:= (s0-calc_sum) * 7 + (maxy-1-(by+b_miny)) * 1;}  {k=14%}
          {t:= (s0-calc_sum) * 8 + (maxy-1-(by+b_miny)) * 1; } {k=15%}
          {t:= (s0-calc_sum) * 9 + (maxy-1-(by+b_miny)) * 1;} {k=15%}
          {t:= (s0-calc_sum) * 10 + (maxy-1-(by+b_miny)) * 1;} {k=14%}
          {t:= (s0-calc_sum) * 15 + (maxy-1-(by+b_miny)) * 1;} {k=14%}
          t:= (s0-calc_sum) * 5 + (maxy-1-(by+b_miny)) * 1;  {k=15%}
          apply_b(0);

          if (v=-1) or (t<=v) then
          begin
            if (t<v) or (v=-1) then max:=0;
            inc(max);
            arr[max].bx:=bx;
            arr[max].by:=by;
            arr[max].br:=br;
            v:=t;
          end;

        end;

      end;
    end;


    t:=1+random(max);
    _bx:=arr[t].bx;
    _by:=arr[t].by;
    _br:=arr[t].br;

    if play=1 then
    begin
      bx:=_bx;
      by:=_by;
      br:=_br;
      rot_b(br);
      apply_b($FF);
      draw_a;
      apply_b(0);
      delay(100);
    end;

    bx:=save_bx;
    by:=save_by;
    br:=save_br;
    rot_b(br);
  end;

var
  x7,i,key:integer;

  port60,m,mb1,mb2,mb3,mb1t,mb2t,mb3t : word;

begin
  randomize;
  {randseed:=1;}

  move(mem[segb800:0],buf,sizeof(buf));
  move(buf,buf2,sizeof(buf2));

  asm
    MOV AH, 01H
    MOV CX, 0FF00H
    INT 10H
  end;

  play:=0;
  for i:=1  to paramcount do
    if paramstr(i)='/play' then
      play:=1;

  if play=1 then
  emptychr:='';

  while keypressed do readkey;

  if play=0 then
  begin
    asm
      mov     ax, 0000h
      int     33h
      mov     m, ax
      mov     ax, 0003h
      int     33h
      mov     mb1,bx
      mov     mb2,cx
      mov     mb3,dx
    end;
    port60:=port[$60];
  end;

  for x7 :=0 to 80*25-1 do
  begin
    mem[segb800:x7*2+1]:=8;
    buf2[x7*2+1]:=8;
  end;

  repeat

    init_a;
    init_b;
    findbest;

    inc(pcount);
    updinfo;

    repeat

      inc(by);

      if not can_apply_b then
      begin
        dec(by);

        apply_b($FF);
        draw_a;
        delay(100);
        apply_b(bc);

        check_a;
        init_b;
        findbest;
        inc(pcount);
        updinfo;
        if not can_apply_b then break;
      end;

      for i:=1 to N_CYCLE do
      begin

        delay(N_DELAY);

        apply_b(bc);
        draw_a;
        apply_b(0);

        key:=0;

        if play=0 then begin

          key:=0;
          if br<>_br then key:=4 else
          if bx<_bx then key:=2 else
          if bx>_bx then key:=3 else
          if _by<>by then key:=1;

{$IFDEF DEBUG}
          if keypressed and (readkey=#27) then
            key:=6;
{$ELSE}
          if m<>0 then
          begin
            asm
              mov     ax, 0003h
              int     33h
              mov     mb1t,bx
              mov     mb2t,cx
              mov     mb3t,dx
            end;
            if (mb1t<>mb1) or (mb2t<>mb2) or (mb3t<>mb3) then
              key:=6;
          end;

          if port[$60] <> port60 then key:=6;
{$ENDIF}

        end else begin

          if keypressed then
          case readkey of
            #27: key:=6;
            #32: key:=1;
            #00: case readkey of
                   'M': key:=2;
                   'K': key:=3;
                   'H': key:=4;
                   'P': key:=5;
                 end;
          end;

        end;

        case key of
          6: begin
               while keypressed do readkey;
               move(buf,mem[segb800:0],sizeof(buf));
               asm
                 MOV AH, 01H
                 MOV CX, 0607H
                 INT 10H
               end;
               halt;
             end;
          1: begin
               repeat
                 apply_b(bc);
                 draw_a;
                 apply_b(0);
                 delay(N_DELAY_DOWN);
                 inc(by);
               until not can_apply_b;
               dec(by);
             end;
          2: begin inc(bx); if not can_apply_b then dec(bx); end;
          3: begin dec(bx); if not can_apply_b then inc(bx); end;
          4: begin
               br:=(br+1) mod 4;
               rot_b(br);
               if not can_apply_b then
               begin
                 inc(bx);
                 if not can_apply_b then
                   dec(bx)
                 else begin
                   dec(bx);
                   if not can_apply_b then
                     inc(bx);
                 end;
                 if not can_apply_b then
                 begin
                   br:=(br+3) mod 4;
                   rot_b(br);
                 end;
               end;
             end;
          5: begin inc(by); if not can_apply_b then dec(by); end;
        end;

        if _by=by then break;

      end;

    until false;

    inc(gcount);

  until false;

end.
