
o               equ (word ptr 0)
s               equ (word ptr 2)

capslock        equ 1000000b
alt             equ    1000b
ctrl            equ     100b
leftshift       equ      10b
rightshift      equ       1b

ruscolor        equ 1  ; 11
altcolor        equ 10 ; 39

normalmode      equ 0
rusmode         equ 1
altmode         equ 2

key             equ 46h    ; scroll lock //right shift scancode
maska           equ alt + ctrl + leftshift + rightshift

isbeep          equ 0

is08            equ 1
font08start     equ 0
font08end       equ 255

is14            equ 1
font14start     equ 0
font14end       equ 255

is16            equ 1
font16start     equ 0
font16end       equ 255

                .model  tpascal
                .386p
                .code
;                assume  cs:code, ds:code, es:code, ss:code
                locals  @@

                org     100h
start:
        if is08+is14+is16 eq 0
                jmp     init
       else
                jmp     build
       endif

shift           db      0
mode            db      0

keys            db      10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1ah
                db      1bh,1eh,1fh,20h,21h,22h,23h,24h,25h,26h,27h
                db      28h,2ch,2dh,2eh,2fh,30h,31h,32h,33h,34h,35h, 0

RUSKEY          DB      '㪥뢠஫ᬨ'
RUSKEYUP        DB      ''
ALTKEY          DB      "¿ҷĺ[]Ŵ׶;'н,./"
ALTKEYUP        DB      '˻Ѹ{}ιص:"ʼϾ<>?'

int09:          pusha
                push    ds

                push    cs
                pop     ds

                in      al, 60h
                mov     ch, al              ; ch = scan  ᨬ

                mov     ah, 02h             ; al = kbd status
                int     16h

                test    al, ctrl           ; 室 ᫨  ctrl
                jnz     @@exit

                test    al, maska          ; jmp checkkey ᫨
                jnz     @@checkkey         ;  ctrl, alt  leftshift

                cmp     ch, key            ; rightshift ?
                jne     @@not_hotkey

@@hotkey:       inc     shift               ; ᪮쪮 ࠧ  hotkey

                jmp     @@exit

@@not_hotkey:   cmp     ch, key + 128
                jne     @@checkkey

@@hot_released: cmp     shift, 1            ; hotkey    ࠧ ?
                mov     shift, 0
                jne     @@exit

                call    changemode         ; 塞 ० normal/rus/alt
                call    setcolor           ; ⠭ 梥

                jmp     @@exit

@@checkkey:     mov     shift, 0            ; 뢠 ᫮  hotkey

                test    ch, 128            ;  饭 ? - 室
                jnz     @@exit

                cmp     mode, normalmode    ; ० normal ? - 室
                je      @@exit

                lea     si, keys            ; 饬 scancode  젡
                cld

@@2:            lodsb

                or      al, al               ; 0 =  ⠡
                jz      @@exit

                cmp     al, ch              ;   ?
                jne     @@2

                lea     bx, ruskey          ; mode=rus - ruskey
                cmp     mode, rusmode       ; mode=alt - altkey
                je      @@rus_mode
@@alt_mode:     lea     bx, altkey

@@rus_mode:     mov     ah, 02h             ;  ࠧ  
                int     16h

                test    al, alt            ;  alt ?
                jz      @@not_alt

@@alt:          lea     bx, altkey          ; alt pressed: ,./

@@not_alt:      and     al, capslock + leftshift + rightshift

                cmp     al, capslock        ;  capslock  leftshift
                je      @@up                 ;  rightshift ?
                cmp     al, leftshift       ; - jmp @@up
                je      @@up
                cmp     al, rightshift
                jne     @@6

@@up:           add     bx, ruskeyup-ruskey

@@6:            sub     si, offset keys + 1
                mov     cl, [bx+si]

                xor     ch, ch  ; p᪠ 'p'  

                mov     ah, 5
                int     16h

                mov     al, 20h
                out     20h, al

                pop     ds
                popa
                iret

                ;;

@@exit:         pop     ds
                popa

                db      0eah
old09           dd      ?

changemode:     inc     cs:mode
                cmp     cs:mode, 3
                jne     @@1
                mov     cs:mode, 0

@@1:   if isbeep ne 0
                call    beep
       endif

                push    ax es
                push    0
                pop     es
                mov     al, cs:mode
                mov     es:[4e0h], al
                pop     es ax

                ret

       if isbeep ne 0

beep            proc    near
                uses    ax, cx

                mov     al, 0b6h
                out     43h, al

                mov     ax, 1010
                out     42h, al
                mov     al, ah
                out     42h, al

                in      al, 61h
                or      al, 3
                out     61h, al

                xor     cx, cx
                loop $
                loop $
                loop $

                in      al, 61h
                and     al, 0fch
                out     61h, al

                ret
                endp

       endif

int10:          cmp     ah, 00h
                je      ah00
                cmp     ax, 1112h
                je      ax1112

                cmp     ah, 88h
                je      ah88

exit10:         db      0eah
old10           dd      ?

call10:         pushf
                call    cs:old10
                ret

ax1112:         ;;

ah00:           call    call10

        if is08+is14+is16 ne 0
                call    setfont
        endif

                call    setcolor

                iret

ah88:           dec     al
                js      al00
                jz      al01
                dec     al
                jz      al02
                iret

al00:           inc     cx
                iret

al01:           mov     al, cs:mode
                iret

al02:           call    changemode
                call    setcolor
                iret

       if is08+is14+is16 ne 0

setfont:        pusha
                push    es

                mov     ax, 0b800h
                mov     es, ax

                xor     bx, bx

                mov     ax, es:[bx]
                inc     ax
                jz      @@3

               ; call beep

                mov     es, bx

                mov     bh, es:[0485h]

                if is08 eq 1
                cmp     bh, 08
                jne     @@1
                lea     bp, font08
                jmp     @@4
                endif

@@1:            if is14 eq 1
                cmp     bh, 14
                jne     @@2
                lea     bp, font14
                jmp     @@4
                endif

@@2:            if is16 eq 1
                cmp     bh, 16
                jne     @@3
                lea     bp, font16
                endif

@@4:            push cs
                pop     es
                mov     dx, cs:[bp]
                mov     cx, cs:[bp]+2
                add     bp, 4
                mov     ax, 1100h
                call    call10

@@3:            pop     es
                popa

                ret

        endif

color           db      0,ruscolor,altcolor

setcolor        proc    near
                uses    ax,bx
                mov     ax, 1001h
                xor     bh, bh
                mov     bl, cs:mode
                mov     bh, cs:color[bx]
                call    call10
                ret
                endp

       if is08 eq 1
font08          dw font08start,font08end-font08start+1
                db (font08end-font08start+1)*08 dup (?)
       endif

       if is14 eq 1
font14          dw font14start,font14end-font14start+1
                db (font14end-font14start+1)*14 dup (?)
       endif

       if is16 eq 1
font16          dw font16start,font16end-font16start+1
                db (font16end-font16start+1)*16 dup (?)
       endif

memory          equ ($-start+256+15)/16

init:           mov     ah, 9
                lea     dx, initmsg
                int     21h

       if isbeep ne 0
                call    beep
       endif

                mov     ax, 8800h
                xor     cx, cx
                int     10h
                jcxz    @@1

                mov     ah, 9
                lea     dx, alredymsg
                int     21h

                mov     ax, 4c01h
                int     21h

@@1:            mov     ah, 9
                lea     dx, instmsg
                int     21h

                mov     ax, 3509h
                int     21h
                mov     old09.o, bx
                mov     old09.s, es

                mov     ax, 3510h
                int     21h
                mov     old10.o, bx
                mov     old10.s, es

                mov     ax, 2509h
                lea     dx, int09
                int     21h

                mov     ax, 2510h
                lea     dx, int10
                int     21h

       if is08+is14+is16 ne 0
                call     setfont
       endif

                mov     ah, 49h
                mov     es, ds:[002ch]
                int     21h

                mov     ax, 3100h
                mov     dx, memory
                int     21h

initmsg         db 13,10,'keyrus: $'

instmsg:        if memory*16 ge 10000
                db (memory*16/10000) mod 10+'0'
                endif

                if memory*16 ge 1000
                db (memory*16/1000) mod 10+'0'
                endif

                db (memory*16/100)  mod 10+'0'
                db (memory*16/10)   mod 10+'0'
                db (memory*16/1)    mod 10+'0'
                db ' bytes of memory used',13,10,13,10,'$'

alredymsg       db 'alredy installed',13,10,'$'

       if is08+is14+is16 ne 0

build: if is08 eq 1
                lea dx, font08file
                lea si, font08+4
                mov di, font08start*08
                mov cx, (font08end-font08start+1)*08
                call loadfont
       endif

       if is14 eq 1
                lea dx, font14file
                lea si, font14+4
                mov di, font14start*14
                mov cx, (font14end-font14start+1)*14
                call loadfont
       endif

       if is16 eq 1
                lea dx, font16file
                lea si, font16+4
                mov di, font16start*16
                mov cx, (font16end-font16start+1)*16
                call loadfont
       endif

                mov word ptr start + 1, init - start - 3

                push ds

                mov ds, ds:[002ch]
                xor si, si
                cld
@@1:            lodsb
                or al, [si]
                jnz @@1
                lea dx, [si+3]

                mov ah, 3ch
                mov cx, 32
                int 21h

                pop ds

                xchg bx, ax

                mov ah, 40h
                lea dx, start
                mov cx, build - start
                int 21h

                mov ah, 3eh
                int 21h

                jmp init

loadfont:       mov ax, 3d02h
                int 21h
                jc @@1

                xchg bx, ax

                push cx
                mov ax, 4200h
                xor cx, cx
                mov dx, di
                int 21h
                pop cx

                mov ah, 3fh
                mov dx, si
                int 21h

                mov ah, 3eh
                int 21h

                ret

@@1:            mov ah, 9
                lea dx, errmsg
                int 21h

                mov ax, 4c00h
                int 21h

errmsg          db 13,10,'keyrus: font file(s) not found',13,10,13,10,'$'

       if is08 eq 1
font08file      db '8x08.fnt',0
       endif

                if is14 eq 1
font14file      db '8x14.fnt',0
       endif

       if is16 eq 1
font16file      db '8x16.fnt',0
       endif

       endif

                end     start

