
; ࠭  VMM.INC

TCB                     STRUC
TCB_Flags               DD      ?       ; Thread status flags
TCB_Reserved1           DD      ?       ; Used internally by VMM
TCB_Reserved2           DD      ?       ; Used internally by VMM
TCB_Signature           DD      ?       ; 'THCB'
TCB_ClientPtr           DD      ?       ; Client registers of thread
TCB_VMHandle            DD      ?       ; VM that thread is part of
TCB_ThreadId            DW      ?       ; Unique Thread ID
TCB_PMLockOrigSS        DW      ?       ; Original SS:ESP before lock stack
TCB_PMLockOrigESP       DD      ?       ;
TCB_PMLockOrigEIP       DD      ?       ; Original CS:EIP before lock stack
TCB_PMLockStackCount    DD      ?       ;
TCB_PMLockOrigCS        DW      ?       ;
TCB_PMPSPSelector       DW      ?       ;
TCB_ThreadType          DD      ?       ; dword passed to VMMCreateThread
TCB_pad1                DW      ?       ; reusable; for dword align
TCB_pad2                DB      ?       ; reusable; for dword align
TCB_extErrLocus         DB      ?       ; extended error Locus
TCB_extErr              DW      ?       ; extended error Code
TCB_extErrAction        DB      ?       ; extended error Action
TCB_extErrClass         DB      ?       ; extended error Class
TCB_extErrPtr           DD      ?       ; extended error pointer
TCB                     ENDS

SCHED_OBJ_ID_THREAD             EQU     42434854H   ; THCB

THFLAG_SUSPENDED_BIT            EQU     03H
THFLAG_SUSPENDED                EQU     (1 SHL THFLAG_SUSPENDED_BIT)
THFLAG_NOT_EXECUTEABLE_BIT      EQU     04H
THFLAG_NOT_EXECUTEABLE          EQU     (1 SHL THFLAG_NOT_EXECUTEABLE_BIT)
THFLAG_THREAD_CREATION_BIT      EQU     08H
THFLAG_THREAD_CREATION          EQU     (1 SHL THFLAG_THREAD_CREATION_BIT)
THFLAG_THREAD_BLOCKED_BIT       EQU     0AH
THFLAG_THREAD_BLOCKED           EQU     (1 SHL THFLAG_THREAD_BLOCKED_BIT)
THFLAG_RING0_THREAD_BIT         EQU     1CH
THFLAG_RING0_THREAD             EQU     (1 SHL THFLAG_RING0_THREAD_BIT)
THFLAG_CHARSET_BITS             EQU     10H
THFLAG_CHARSET_MASK             EQU     (3 SHL THFLAG_CHARSET_BITS)
THFLAG_ANSI                     EQU     (0 SHL THFLAG_CHARSET_BITS)
THFLAG_OEM                      EQU     (1 SHL THFLAG_CHARSET_BITS)
THFLAG_UNICODE                  EQU     (2 SHL THFLAG_CHARSET_BITS)
THFLAG_RESERVED                 EQU     (3 SHL THFLAG_CHARSET_BITS)
THFLAG_EXTENDED_HANDLES_BIT     EQU     12H
THFLAG_EXTENDED_HANDLES         EQU     (1 SHL THFLAG_EXTENDED_HANDLES_BIT)
THFLAG_OPEN_AS_IMMOVABLE_FILE_BIT EQU   13H
THFLAG_OPEN_AS_IMMOVABLE_FILE   EQU     (1 SHL THFLAG_OPEN_AS_IMMOVABLE_FILE_BIT)

Client_Reg_Struc        STRUC
Client_EDI              DD      ?       ; +00
Client_ESI              DD      ?       ; +04
Client_EBP              DD      ?       ; +08
Client_res0             DD      ?       ; +0C
Client_EBX              DD      ?       ; +10
Client_EDX              DD      ?       ; +14
Client_ECX              DD      ?       ; +18
Client_EAX              DD      ?       ; +1C
Client_Error            DD      ?       ; +20
Client_EIP              DD      ?       ; +24
Client_CS               DW      ?       ; +28
Client_res1             DW      ?
Client_EFlags           DD      ?
Client_ESP              DD      ?
Client_SS               DW      ?
Client_res2             DW      ?
Client_ES               DW      ?
Client_res3             DW      ?
Client_DS               DW      ?
Client_res4             DW      ?
Client_FS               DW      ?
Client_res5             DW      ?
Client_GS               DW      ?
Client_res6             DW      ?
Client_Alt_EIP          DD      ?
Client_Alt_CS           DW      ?
Client_res7             DW      ?
Client_Alt_EFlags       DD      ?
Client_Alt_ESP          DD      ?
Client_Alt_SS           DW      ?
Client_res8             DW      ?
Client_Alt_ES           DW      ?
Client_res9             DW      ?
Client_Alt_DS           DW      ?
Client_res10            DW      ?
Client_Alt_FS           DW      ?
Client_res11            DW      ?
Client_Alt_GS           DW      ?
Client_res12            DW      ?
Client_Reg_Struc        ENDS
