%%
%%  (C) 2003 Chris Rathman
%%

%% reserve some space for a stack  (note: each stack entry takes two cells ~ value and a walk byte)
>> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>
>> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>
>> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>

%%
%% Object Definition:
%%
%%                      <   object#                                                     >
%%                     <<   function#/step#                                             >>
%%                    <<<   class#                                                      >>>
%%                   <<<<   slot#1   (main!shape(0) | circle!x      | rectangle!x)      >>>>
%%                  <<<<<   slot#2   (main!shape(1) | circle!y      | rectangle!y)      >>>>>
%%                 <<<<<<   slot#3   (main!rect     | circle!radius | rectangle!width)  >>>>>>
%%                <<<<<<<   slot#4   (              |               | rectangle!height) >>>>>>>
%%               <<<<<<<<   slot#5                                                      >>>>>>>>
%%              <<<<<<<<<   reserved                                                    >>>>>>>>>
%%   <<<<<<<<<<<<<<<<<<<<   object length                                               >>>>>>>>>>>>>>>>>>>>
%%

%% auto-allocate main root object
>>>>>>>>>>>>   9~20  %% workspace (for previous object)
[-]>           8     %% slot#5
[-]>           7     %% slot#4
[-]>           6     %% slot#3
[-]>           5     %% slot#2
[-]>           4     %% slot#1
[-]>           3     %% class#
[-]>           2     %% function#/step#
[-]>           1     %% object#

%% stack push step#1 for main object
<<<<<<<<<<<<<<<<<<<< [<<]+<+>[>>]<< >>>>>>>>>>>>>>>>>>>>                            %% stack push step#
<<<<<<<<<<<<<<<<<<<< [<<]+<> [>>]<< >>>>>>>>>>>>>>>>>>>>                            %% stack push object#

<<<<<<<<<<<<<<<<<<<< <<[>> >>>>>>>>>>>>>>>>>>>>                                     %% while stack do

   <<<<<<<<<<<<<<<<<<<< [<<] >>                                                     %% stack pull next object#
      <[> [>>] << >>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
   [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>

   <<<<<<<<<<<<<<<<<<<< [<<] >>                                                     %% stack pull next function#/step#
      <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
   [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
   [                                                                                %% walk to next object#n
      >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
      [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
      >>>>>>>>>>>>>>>>>>>>
   -]

   <<[-]>> >[<< <+> >>-]<                                                           %% set function#/step# for the object


   ================================================================================================
   = main process                                                                                 =
   ================================================================================================
   [-]<<<[>>>+>+<<< <-]>>>  >[<<< <+> >>>-]<                                        %% get class#
   >[-] [<->-]< >[-]< [>[-]+<-] >- [[-]<                                            %% IF (class#0)

      %% set to return to the next step# after continue
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]< +                                          %% get step#
      <<<<<<<<<<<<<<<<<<<< [<<]+<++++>    [>>]<< >>>>>>>>>>>>>>>>>>>>               %% stack push step#
      <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>  [>>]<< >>>>>>>>>>>>>>>>>>>>                  %% stack mark spot for step#
      [<<<<<<<<<<<<<<<<<<<< [<<]>+>    [>>]<< >>>>>>>>>>>>>>>>>>>>-]                %% stack push step#
      <<<<<<<<<<<<<<<<<<<< [<<]+<[-]> [>>]<< >>>>>>>>>>>>>>>>>>>>                   %% stack push object#

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#1 new shape()                                                                        %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                        %% IF (function#1)

         %% allocate a new object in the heap
         <[<<<<<<<<<<<<<<<<<<<<]>                                                   %% walk back to root object
         >>>>>>>>>>>>>>>>>>>>                                                       %% skip over first object
         <[>                                                                        %% find free space in the heap
            [-]<[>+>+< <-]> >[< <+> >-]<                                            %% get object#
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<<-]
            >>>>>>>>>>>>>>>>>>>>
         <]>
         <[-]+ >[<+>-]<>                                                            %% object#n
         <<<[-]+>>>                                                                 %% class# rectangle
         [-]<[>+>+< <-]>  >[< <+> >-]<                                              %% get new object#
         <[                                                                         %% walk back to root object
           >[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]<
           <<<<<<<<<<<<<<<<<<<<
         ]>

         %% set local slot# for shape(0)
         [<<<< + >>>> -]                                                            %% set slot# shape(0)

         %% make a function call: shape(0) = new rectangle(x,y,width,height)
         <<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                                %% get shape(0) from slot
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# height = 6
            <++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# width = 5
            <+++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# y = 20
            <++++++++++++++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# x = 10
            <++++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+<+>   [>>]<< >>>>>>>>>>>>>>>>>>>>                %% stack push function# rectangle
         <<<<<<<<<<<<<<<<<<<< [<<]+<[-]> [>>]<< >>>>>>>>>>>>>>>>>>>>                %% stack mark spot for object#
         [<<<<<<<<<<<<<<<<<<<< [<<]>+>   [>>]<< >>>>>>>>>>>>>>>>>>>>-]              %% stack push object# shape(0)

         %% allocate a new object in the heap
         <[<<<<<<<<<<<<<<<<<<<<]>                                                   %% walk back to root object
         >>>>>>>>>>>>>>>>>>>>                                                       %% skip over first object
         <[>                                                                        %% find free space in the heap
            [-]<[>+>+< <-]> >[< <+> >-]<                                            %% get object#
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<<-]
            >>>>>>>>>>>>>>>>>>>>
         <]>
         <[-]+ >[<+>-]<>                                                            %% object#n
         <<<[-]++>>>                                                                %% class#
         [-]<[>+>+< <-]>  >[< <+> >-]<                                              %% get new object#
         <[                                                                         %% walk back to root object
           >[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]<
           <<<<<<<<<<<<<<<<<<<<
         ]>

         %% set local slot# for shape(1)
         [<<<<< + >>>>> -]                                                          %% set slot# shape(1)

         %% make a function call: shape(1) = new circle(x,y,radius)
         <<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                          %% get shape(1) from slot
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# radius = 8
            <++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# y = 25
            <+++++++++++++++++++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# x = 15
            <+++++++++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+<+>   [>>]<< >>>>>>>>>>>>>>>>>>>>                %% stack push function# circle
         <<<<<<<<<<<<<<<<<<<< [<<]+<[-]> [>>]<< >>>>>>>>>>>>>>>>>>>>                %% stack mark spot for object#
         [<<<<<<<<<<<<<<<<<<<< [<<]>+>   [>>]<< >>>>>>>>>>>>>>>>>>>>-]              %% stack push object# shape(1)
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#2 shape!draw()                                                                       %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                       %% IF (function#2)
         %% get the two shapes to process
         <<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                                %% get shape(0) from slot
         [>>>>+<<<<-]                                                               %% push shape(0) in the workspace
         <<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                          %% get shape(1) from slot
         [>>>>>+<<<<<-]                                                             %% push shape(1) in the workspace

         %% make a function call: shape(i)!draw()
         >>>++[-<<<                                                                 %% for i = 1 downto 0
            >>>>[<<<<+>>>>-]<<<<                                                    %% get next shape to process
            <<<<<<<<<<<<<<<<<<<< [<<]+<++++> [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack push function# draw
            <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>  [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack mark spot for object#
            [<<<<<<<<<<<<<<<<<<<< [<<]>+>    [>>]<< >>>>>>>>>>>>>>>>>>>>-]          %% stack push object# shape(0)
            >>>>>[<+>-]<<<<<                                                        %% pull down next shape
         >>>]<<<
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#3 shape!rMoveTo()                                                                    %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                      %% IF (function#3)
         %% get the two shapes to process
         <<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                                %% get shape(0) from slot
         [>>>>+<<<<-]                                                               %% push shape(0) in the workspace
         <<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                          %% get shape(1) from slot
         [>>>>>+<<<<<-]                                                             %% push shape(1) in the workspace

         %% make a function call: shape(i)!rMoveTo(100)
         >>>++[-<<<                                                                 %% for i = 1 downto 0
            >>>>[<<<<+>>>>-]<<<<                                                    %% get next shape to process
            <<<<<<<<<<<<<<<<<<<< [<<]                                               %% stack push param# dy = 100
               <++++[>+++++<-]>[<+++++>-]<>+
            [>>]<< >>>>>>>>>>>>>>>>>>>>
            <<<<<<<<<<<<<<<<<<<< [<<]                                               %% stack push param# dx = 100
               <++++[>+++++<-]>[<+++++>-]<>+
            [>>]<< >>>>>>>>>>>>>>>>>>>>
            <<<<<<<<<<<<<<<<<<<< [<<]+<+++>  [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack push function# rmoveto
            <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>  [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack mark spot for object#
            [<<<<<<<<<<<<<<<<<<<< [<<]>+>    [>>]<< >>>>>>>>>>>>>>>>>>>>-]          %% stack push object# shape(0)
            >>>>>[<+>-]<<<<<                                                        %% pull down next shape
         >>>]<<<
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#4 shape!draw()                                                                       %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                     %% IF (function#4)
         %% get the two shapes to process
         <<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                                %% get shape(0) from slot
         [>>>>+<<<<-]                                                               %% push shape(0) in the workspace
         <<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                          %% get shape(1) from slot
         [>>>>>+<<<<<-]                                                             %% push shape(1) in the workspace

         %% make a function call: shape(i)!draw()
         >>>++[-<<<                                                                 %% for i = 1 downto 0
            >>>>[<<<<+>>>>-]<<<<                                                    %% get next shape to process
            <<<<<<<<<<<<<<<<<<<< [<<]+<++++> [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack push function# draw
            <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>  [>>]<< >>>>>>>>>>>>>>>>>>>>            %% stack mark spot for object#
            [<<<<<<<<<<<<<<<<<<<< [<<]>+>    [>>]<< >>>>>>>>>>>>>>>>>>>>-]          %% stack push object# shape(0)
            >>>>>[<+>-]<<<<<                                                        %% pull down next shape
         >>>]<<<
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#5 new rect()                                                                         %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (function#5)

         %% allocate a new object in the heap
         <[<<<<<<<<<<<<<<<<<<<<]>                                                   %% walk back to root object
         >>>>>>>>>>>>>>>>>>>>                                                       %% skip over first object
         <[>                                                                        %% find free space in the heap
            [-]<[>+>+< <-]> >[< <+> >-]<                                            %% get object#
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<<-]
            >>>>>>>>>>>>>>>>>>>>
         <]>
         <[-]+ >[<+>-]<>                                                            %% object#n
         <<<[-]+>>>                                                                 %% class# rectangle
         [-]<[>+>+< <-]>  >[< <+> >-]<                                              %% get new object#
         <[                                                                         %% walk back to root object
           >[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]<
           <<<<<<<<<<<<<<<<<<<<
         ]>

         %% set local slot# for rect
         [<<<<<< + >>>>>> -]                                                        %% set slot# rect

         %% make a function call: rect = new rectangle(x,y,width,height)
         <<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> >[<<<<<< <+> >>>>>>-]<                    %% get rect from slot#
         <<<<<<<<<<<<<<<<<<<< [<<]+<+++++++++++++++>[>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack push param# height=15
         <<<<<<<<<<<<<<<<<<<< [<<]+<+++++++++++++++>[>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack push param# width=15
         <<<<<<<<<<<<<<<<<<<< [<<]+<>               [>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack push param# y=0
         <<<<<<<<<<<<<<<<<<<< [<<]+<>               [>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack push param# x=0
         <<<<<<<<<<<<<<<<<<<< [<<]+<+>              [>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack push function# circle
         <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>            [>>]<< >>>>>>>>>>>>>>>>>>>>     %% stack mark spot for object#
         [<<<<<<<<<<<<<<<<<<<< [<<]>+>              [>>]<< >>>>>>>>>>>>>>>>>>>>-]   %% stack push object# rect
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#6 rect!setWidth()                                                                    %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                   %% IF (function#6)
         %% make a function call: rect!setRadius(radius)
         <<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> >[<<<<<< <+> >>>>>>-]<                    %% get rect from slot#
         <<<<<<<<<<<<<<<<<<<< [<<]+                                                 %% stack push param# radius=30
            <++++++++++++++++++++++++++++++>
         [>>]<< >>>>>>>>>>>>>>>>>>>>
         <<<<<<<<<<<<<<<<<<<< [<<]+<+++++>    [>>]<< >>>>>>>>>>>>>>>>>>>>           %% stack push function# setRadius=30
         <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>      [>>]<< >>>>>>>>>>>>>>>>>>>>           %% stack mark spot for object#
         [<<<<<<<<<<<<<<<<<<<< [<<]>+>        [>>]<< >>>>>>>>>>>>>>>>>>>>-]         %% stack push object# rect
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#7 rect!draw()                                                                        %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                  %% IF (function#7)
         %% make a function call: rect!draw()
         <<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> >[<<<<<< <+> >>>>>>-]<                    %% get shape(0) from slot
         <<<<<<<<<<<<<<<<<<<< [<<]+<++++> [>>]<< >>>>>>>>>>>>>>>>>>>>               %% stack push function# draw
         <<<<<<<<<<<<<<<<<<<< [<<]+<[-]>  [>>]<< >>>>>>>>>>>>>>>>>>>>               %% stack mark spot for object#
         [<<<<<<<<<<<<<<<<<<<< [<<]>+>    [>>]<< >>>>>>>>>>>>>>>>>>>>-]             %% stack push object# rect
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % step#8 exit()                                                                             %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                 %% IF (function#8)
         <<<<<<<<<<<<<<<<<<<< <<[-]>> >>>>>>>>>>>>>>>>>>>>                          %% kill stack to exit
      >]<                                                                           %% END IF (function#99)

   >]<                                                                              %% END IF (class#0)



   ================================================================================================
   = rectangle class                                                                              =
   ================================================================================================
   [-]<<<[>>>+>+<<< <-]>>>  >[<<< <+> >>>-]<                                        %% get class#
   >[-]+  [<->-]< >[-]< [>[-]+<-] >- [[-]<                                          %% IF (class#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#1 rectangle(x,y,width,height)                                                    %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                        %% IF (function#1)
         %% clear the slots
         <<<<[-]>>>>                                                                %% x=0
         <<<<<[-]>>>>>                                                              %% y=0
         <<<<<<[-]>>>>>>                                                            %% width=0
         <<<<<<<[-]>>>>>>>                                                          %% height=0

         %% grab the x value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y

         %% grab the width value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# width
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<+>>>>>> >-]<                                                     %% set slot# width

         %% grab the height value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# height
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<<+>>>>>>> >-]<                                                   %% set slot# height
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#2 moveTo(x,y)                                                                    %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                       %% IF (function#2)
         %% grab the x value from the stack
         <<<<[-]>>>>                                                                %% x=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <<<<<[-]>>>>>                                                              %% y=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y
      >]<                                                                           %% END IF (function#2)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#3 rMoveTo(x,y)                                                                   %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                      %% IF (function#3)
         %% grab the x value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y
      >]<                                                                           %% END IF (function#3)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#5 setWidth(width)                                                                %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (function#5)
         %% grab the width value from the stack
         <<<<<<[-]>>>>>>                                                            %% width=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# width
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<+>>>>>> >-]<                                                     %% set slot# width
      >]<                                                                           %% END IF (function#5)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#6 setHeight(height)                                                              %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                   %% IF (function#6)
         %% grab the height value from the stack
         <<<<<<[-]>>>>>>                                                            %% height=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# height
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<<+>>>>>>> >-]<                                                   %% set slot# height
      >]<                                                                           %% END IF (function#5)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#4 draw()                                                                         %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                     %% IF (function#4)
         [-]   #64# >++++++++[<++++++++>-]<  ++++.                                  %% D
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++.                    %% R
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++++++++++++++++.               %% W
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++.                        %% N
         [-]   #64# >++++++++[<++++++++>-]<  +++++++.                               %% G
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++.                    %% R
         [-]   #64# >++++++++[<++++++++>-]<  +++++.                                 %% E
         [-]   #64# >++++++++[<++++++++>-]<  +++.                                   %% C
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++++.                  %% T
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++.                        %% N
         [-]   #64# >++++++++[<++++++++>-]<  +++++++.                               %% G
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++.                          %% L
         [-]   #64# >++++++++[<++++++++>-]<  +++++.                                 %% E
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++++.                  %% T
         [-]   #30# >+++++++[<++++++++>-]<   ++.                                    %% :
         [-]   #42# >++++++[<+++++++>-]<     --.                                    %% (
         [-]   <<<<[>>>>+>+<<<< <-]>>>> [<<<< + >>>>-]                              %% x
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                          %% get slot# x
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (x=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (x=0)
         [-]   #42# >++++++[<+++++++>-]<     ++.                                    %% comma
         [-]   <<<<<[>>>>>+>+<<<<< <-]>>>>> [<<<<< + >>>>>-]                        %% y
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                    %% get slot# y
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (y=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (y=0)
         [-]   #42# >++++++[<+++++++>-]<     -.                                     %% )
         [-]   #42# >++++++[<+++++++>-]<     ++.                                    %% comma
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++++++++++++++++.               %% W
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  ++++.                                  %% D
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++++.                  %% T
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++.                              %% H
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   <<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> [<<<<<< + >>>>>>-]                  %% width
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> >[<<<<<< <+> >>>>>>-]<              %% get slot# width
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (width=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (width=0)
         [-]   #42# >++++++[<+++++++>-]<     ++.                                    %% comma
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++.                              %% H
         [-]   #64# >++++++++[<++++++++>-]<  +++++.                                 %% E
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  +++++++.                               %% G
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++.                              %% H
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++++.                  %% T
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   <<<<<<<[>>>>>>>+>+<<<<<<< <-]>>>>>>> [<<<<<<< + >>>>>>>-]            %% width
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<<<<[>>>>>>>+>+<<<<<<< <-]>>>>>>> >[<<<<<<< <+> >>>>>>>-]<        %% get slot# height
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (height=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (height=0)
         [-]   +++++++++++++.[-]                                                    %% \n
      >]<                                                                           %% END IF (function#4)

   >]<                                                                              %% END IF (class#2)



   ================================================================================================
   = circle class                                                                                 =
   ================================================================================================
   [-]<<<[>>>+>+<<< <-]>>>  >[<<< <+> >>>-]<                                        %% get class#
   >[-]++  [<->-]< >[-]< [>[-]+<-] >- [[-]<                                         %% IF (class#2)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#1 circle(x,y,radius)                                                             %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                        %% IF (function#1)
         %% clear the slots
         <<<<[-]>>>>                                                                %% x=0
         <<<<<[-]>>>>>                                                              %% y=0
         <<<<<<[-]>>>>>>                                                            %% radius=0

         %% grab the x value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y

         %% grab the radius value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# radius
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<+>>>>>> >-]<                                                     %% set slot# radius
      >]<                                                                           %% END IF (function#1)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#2 moveTo(x,y)                                                                    %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                       %% IF (function#2)
         %% grab the x value from the stack
         <<<<[-]>>>>                                                                %% x=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <<<<<[-]>>>>>                                                              %% y=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y
      >]<                                                                           %% END IF (function#2)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#3 rMoveTo(x,y)                                                                   %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                      %% IF (function#3)
         %% grab the x value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# x
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<+>>>> >-]<                                                         %% set slot# x

         %% grab the y value from the stack
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# y
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<+>>>>> >-]<                                                       %% set slot# y
      >]<                                                                           %% END IF (function#3)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#5 setRadius(radius)                                                              %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]+++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (function#5)
         %% grab the radius value from the stack
         <<<<<<[-]>>>>>>                                                            %% radius=0
         <[>+>+< <-]> >[< <+> >-]<                                                  %% get object#
         <[>[<<<<<<<<<<<<<<<<<<<< + >>>>>>>>>>>>>>>>>>>>-]< <<<<<<<<<<<<<<<<<<<<]>  %% walk back to root object (drag object#)
         <<<<<<<<<<<<<<<<<<<< [<<] >>                                               %% stack pull param# radius
            <[> [>>] << >>>>>>>>>>>>>>>>>>>> >+< <<<<<<<<<<<<<<<<<<<< [<<] >> <-]>
         [-]>> [>>] << >>>>>>>>>>>>>>>>>>>>
         [                                                                          %% walk to object#n (drag param# & object index)
            >[>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]<
            [>>>>>>>>>>>>>>>>>>>> + <<<<<<<<<<<<<<<<<<<< -]
            >>>>>>>>>>>>>>>>>>>>
         -]
         >[< <<<<<<+>>>>>> >-]<                                                     %% set slot# radius
      >]<                                                                           %% END IF (function#5)

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % function#4 draw()                                                                         %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      [-]<<[>>+>+<< <-]>> >[<< <+> >>-]<                                            %% get function#
      >[-]++++ [<->-]< >[-]< [>[-]+<-] >- [[-]<                                     %% IF (function#4)
         [-]   #64# >++++++++[<++++++++>-]<  ++++.                                  %% D
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++.                    %% R
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++++++++++++++++.               %% W
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++.                        %% N
         [-]   #64# >++++++++[<++++++++>-]<  +++++++.                               %% G
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +++.                                   %% C
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++.                    %% R
         [-]   #64# >++++++++[<++++++++>-]<  +++.                                   %% C
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++.                          %% L
         [-]   #64# >++++++++[<++++++++>-]<  +++++.                                 %% E
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++++.                  %% T
         [-]   #30# >+++++++[<++++++++>-]<   ++.                                    %% :
         [-]   #42# >++++++[<+++++++>-]<     --.                                    %% (
         [-]   <<<<[>>>>+>+<<<< <-]>>>> [<<<< + >>>>-]                              %% x
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<[>>>>+>+<<<< <-]>>>> >[<<<< <+> >>>>-]<                          %% get slot# x
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (x=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (x=0)
         [-]   #42# >++++++[<+++++++>-]<     ++.                                    %% comma
         [-]   <<<<<[>>>>>+>+<<<<< <-]>>>>> [<<<<< + >>>>>-]                        %% y
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<<[>>>>>+>+<<<<< <-]>>>>> >[<<<<< <+> >>>>>-]<                    %% get slot# y
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (y=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (y=0)
         [-]   #42# >++++++[<+++++++>-]<     -.                                     %% )
         [-]   #42# >++++++[<+++++++>-]<     ++.                                    %% comma
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   #64# >++++++++[<++++++++>-]<  ++++++++++++++++++.                    %% R
         [-]   #64# >++++++++[<++++++++>-]<  +.                                     %% A
         [-]   #64# >++++++++[<++++++++>-]<  ++++.                                  %% D
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++.                             %% I
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++++++++++++++.                 %% U
         [-]   #64# >++++++++[<++++++++>-]<  +++++++++++++++++++.                   %% S
         [-]   #30# >+++++[<++++++>-]<       ++.                                    %%
         [-]   <<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> [<<<<<< + >>>>>>-]                  %% radius
            >[                                                                      %% output number
               [>+>+<<-]>>[<<+>>-]<                                                 %% dup
               >+++++++++<[>>>+<< [>+>[-]<<-] >[<+>-]                               %% mod10
                  >[<<++++++++++>>-] <<- <-] +++++++++ >[<->-]<
               [>+<-] < [>+<-] < [>+<-] >>>[<<<+>>>-] <                             %% rrot
               >+++++++++< [ >>>+<< [>+>[-]<<-] >[<+>-]                             %% div10
                  >[<<++++++++++>>>+<-] <<- <- ] >>>>[<<<<+>>>>-]<<<< >[-]<
               <+>                                                                  %% inc1
            ]
            <[
               [>+<-]                                                               %% mover
               +++++++[<+++++++>-]<->                                               %% add48
               <.[-]>                                                               %% putc
               >[<<+>>-]<                                                           %% movel2
            <-]
            [-]<<<<<<[>>>>>>+>+<<<<<< <-]>>>>>> >[<<<<<< <+> >>>>>>-]<              %% get slot# radius
            >[-][<->-]< >[-]< [>[-]+<-] >- [[-]<                                    %% IF (radius=0)
               [-]>[-]+++++++[<+++++++>-]<-.[-]                                     %% output 0 digit
            >]<                                                                     %% END IF (radius=0)
         [-]   +++++++++++++.[-]                                                    %% \n
      >]<                                                                           %% END IF (function#4)

   >]<                                                                              %% END IF (class#2)


   <[<<<<<<<<<<<<<<<<<<<<]>                                                         %% walk back to root object
<<<<<<<<<<<<<<<<<<<< <<]

%%
%% http://www.angelfire.com/tx4/cus/shapes/
%%
